--[[
Main.lua
- Uses Sensor (own tab), IncrementingCell (own tab), and ScoreTable (own tab)
- Renders the full sheet and routes touches to all interactive cells
]] 

-------------------------------------------------
-- Sample Data (2 teams)
-------------------------------------------------
teams = {
{
id   = 1,
name = "Team 1",
players = {
    { id=1, name="Lecia",  bid=4, took=4, spades=0 },
    { id=2, name="Arthur", bid=2, took=2, spades=5 },
},
hearts       = 0,
queensSpades = true,
moonShot     = false,
spadesScore  = 60,
heartsScore  = 72,
handScore    = -12,
handBags     = 0,
allBags      = 0,
spadesTotal  = 60,
heartsTotal  = 72,
gameTotal    = -12
},
{
id   = 2,
name = "Team 2",
players = {
    { id=3, name="Elena", bid=4, took=7, spades=0 },
    { id=4, name="Jesse", bid=0, took=0, spades=8 },
},
hearts       = 0,
queensSpades = false,
moonShot     = false,
spadesScore  = 0,
heartsScore  = 0,
handScore    = 0,
handBags     = 0,
allBags      = 0,
spadesTotal  = 0,
heartsTotal  = 0,
gameTotal    = 0
}
}

-------------------------------------------------
-- Layout “knobs”
-------------------------------------------------
layout = {
overallWidthPercent   = 92.5, -- of safe area
overallHeightPercent  = 50,   -- of safe area
overallInnerPadding   = 4,    -- inside big rounded box

leftTableWidthPercent = 51,   -- of inner width
gapTablesPercent      = 0,    -- of inner width
tablesHeightPercent   = 99.5, -- of inner height

headerGap = 5,                -- px between header row and data rows
teamGap   = 5,                -- px between team 1 and team 2 blocks
}

-- Left table column fractions (sum of base = 600)
LeftCols = {
nameFrac   = 120/600,
narrowFrac =  80/600,
heartsFrac =  80/600,
}

-- Right table: 7 equal columns
RIGHT = { cols = 7 }

-------------------------------------------------
-- Small helpers (globals used by ScoreTable)
-------------------------------------------------
function clamp(x,a,b) return math.max(a, math.min(b,x)) end

function fitFontSize(text, maxW, maxH, lines)
lines = lines or 1
local try   = maxH / lines * 0.9
local minSz = 8
local steps = 20
pushStyle()
textWrapWidth(0)
for i=1,steps do
fontSize(try)
local w,h = textSize(text)
if w <= maxW*0.98 and h <= maxH*0.98 then
popStyle()
return try
end
try = try - math.max((try - minSz)/(steps - i + 1), 0.5)
if try <= minSz then break end
end
popStyle()
return minSz
end

-- basic cell drawer (used by ScoreTable)
function drawCell(x,y,w,h, label, fontSz, weight)
pushStyle()
fill(255) ; rectMode(CORNER) ; rect(x,y,w,h)
stroke(0) ; strokeWidth(1)   ; noFill() ; rect(x,y,w,h)
if label then
fill(0) ; font("HelveticaNeue") ; fontSize(fontSz or 14) ; textAlign(CENTER)
local cx,cy = x + w/2, y + h/2
if weight == "bold" then text(label, cx+0.5, cy+0.5) end
text(label, cx, cy)
end
popStyle()
end

-------------------------------------------------
-- Globals
-------------------------------------------------
local sheets = nil

-------------------------------------------------
-- Codea lifecycle
-------------------------------------------------
function setup()
    parameter.watch("ElapsedTime")
    parameter.number("overallWidthPercent",  50, 100, layout.overallWidthPercent,  function(v) layout.overallWidthPercent=v  end)
    parameter.number("overallHeightPercent", 1, 100, layout.overallHeightPercent, function(v) layout.overallHeightPercent=v end)
    parameter.number("leftTableWidthPercent",30,  60, layout.leftTableWidthPercent,function(v) layout.leftTableWidthPercent=v end)
    parameter.number("gapTablesPercent",      0,  10, layout.gapTablesPercent,     function(v) layout.gapTablesPercent=v     end)
    parameter.number("headerGap",             0,  20, layout.headerGap,            function(v) layout.headerGap=v            end)
    parameter.number("teamGap",               0,  20, layout.teamGap,              function(v) layout.teamGap=v              end)
    
    -- ✅ correct test runner name
    if T and T.run then T.run() end
    
    -- Start with your existing 'teams' object for the first table
    sheets = ScoreSheets(function() return teams end)
end

function draw()
    background(245)
    
    -- Optional title (fixed at top)
    pushStyle()
    fill(0) ; font("HelveticaNeue-Bold") ; fontSize(28) ; textAlign(LEFT)
    text("Card Game Scoresheet", 16, HEIGHT - 24)
    popStyle()
    
    -- Draw the stack of tables + New Hand button
    if sheets then sheets:draw() end
end

function touched(t)
    if sheets and sheets:touched(t) then return end
end
