-- Cameras

-- Use this function to perform your initial setup
function setup()
    print("Hello Cameras!")
    scene = craft.scene()
    makeSlab()
    scene.camera:add(FullOrbitViewer, vec3(0,0,0), 1, 20, 1000)   
end

function makeSlab()
    local slab = scene:entity()
    slab.model = craft.model(asset.Dependencies.Primitives.RoundedCube)
    slab.scale = vec3(2, 2, 1)   
    slab.material = craft.material(asset.Dependencies.Materials.Basic)
    slab.material.map = readImage(asset.Dependencies.Surfaces.Stone_Brick_Normal)
    slab.position = vec3(0, 0, 0)
    slab.eulerAngles =  vec3(10,-60,-60)
end

function update(dt)
    scene:update(dt)
end

-- This function gets called once every frame
function draw()
    update(DeltaTime)
    scene:draw()
end