function setup()
    s3d = scene.default3d()
    s3d.camera:add(camera.rigs.orbit)
    
    
    heightMap = image.cube(256, false) -- grayscale
    
    sL = makeL("sphere_builder_left", vec3(-1.4, 0, 0))
    sR = makeR("sphere_fullshader_right", vec3( 1.4, 0, 0))

end

function draw()
    doDots()
    s3d:draw()
end

function doDots()
    local face, x, y = math.random(0, 5), math.random(0, 256 - 1), math.random(0, 256 - 1)
    context.push(heightMap, face, 0)
    ellipse(x, y, 12)
    context.pop()
    sL.material.heightMap = heightMap
    sR.material.heightMap = heightMap
end

function makeL(name, pos)
    local e = s3d:entity(name)
    e.mesh = mesh.sphere(0.85, 128, 128)
    e.position = pos

    -- Builder shader (known: deforms, but color output doesn't show change)
    local sh = shader.builder("HeightDebug_Carbide")
        :lit()
        :texture { "heightMap", value = heightMap }
        :number  { "heightScale", value = 0.60 }
        :number  { "threshold",   value = 0.02 }
        :vertex [[
            vec3 dir = normalize(material.worldNormal);
            float h  = texture(heightMap, dir).r;
            material.worldPosition.xyz += dir * (h * heightScale);
        ]]
        :material [[
            vec3 dir = normalize(getWorldNormalVector());
            float h  = texture(heightMap, dir).r;

            float on = step(threshold, h);
            vec3 col = mix(vec3(0.02, 0.02, 0.02), vec3(0.0, 0.35, 1.0), on);

            material.baseColor = vec4(col, 1.0);
            material.metallic  = 0.0;
            material.roughness = 1.0;
        ]]
        :build()

    e.material = material(sh)
    e.material.heightMap   = heightMap

    return e
end

function makeR(name, pos)
    local e = s3d:entity(name)
    e.mesh = mesh.sphere(0.85, 128, 128)
    e.position = pos

    local sh = shader([[
        #version 430
        #include <codea/common.glsl>

        layout(location = POSITION) in vec3 a_position;
        layout(location = NORMAL)   in vec3 a_normal;

        uniform samplerCube heightMap;
        uniform float heightScale;

        out float vH;

        void main()
        {
            float heightScale = 0.60;
            vec3 dir = normalize(a_normal);
            float h  = texture(heightMap, dir).r;
            vH = h;

            vec3 pos = a_position + dir * (h * heightScale);
            gl_Position = u_modelViewProj * vec4(pos, 1.0);
        }
    ]], [[
        #version 430
        #include <codea/common.glsl>

        in float vH;
        uniform float threshold;
        out vec4 FragColor;

        void main()
        {
float threshold = 0.02;
            float on = step(threshold, vH);
            vec3 col = mix(vec3(0.02, 0.02, 0.02), vec3(0.0, 0.35, 1.0), on);
            FragColor = vec4(col, 1.0);
        }
    ]])

    e.material = material(sh)
    e.material.heightMap   = heightMap

    return e
end