--# UI3D
UI3D = class()

function UI3D:init(scene, orbitViewer)
  self.scene = scene
  self.orbitViewer = orbitViewer
  self.root = scene:entity()
  self.root.parent = orbitViewer.entity
  self.previewEnt = createHexTileFromTileModel(board:pendingCandidateModel())
  self.previewEnt.parent = self.root
  self.previewEnt.position = vec3(0.06, 0.08, 0.5)
  self.previewEnt.eulerAngles = vec3(-58, 0, 0)
  self.previewBaseScale = 0.025
  self.previewEnt.scale = vec3(1,1,1) * self.previewBaseScale
end

function UI3D:drawScore()
  pushStyle()
  fontSize(80)
  fill(255)
  textAlign(CENTER)
  text(
    myScore() .. " vs " .. opponentScore(), WIDTH/2, HEIGHT - 100)
  popStyle()
end

function UI3D:refreshPreviewFrom(board)
  local model2D
  local cell = board:getCandidateCell()
  if not cell then
    model2D = board:pendingCandidateModel()
  else
    model2D = cell.tile
  end
  
  self.previewEnt.active = true
  self.previewEnt.model2D = model2D
  refreshTileEntityFromModel(self.previewEnt)
end

function UI3D:update()
  self:drawScore()
  self:updatePreviewBounce()
end

function UI3D:updatePreviewBounce()
  local e = self.previewEnt
  if not e or not e.active then return end
  
  -- 🔧 knobs
  local speed  = 3     -- oscillations per second-ish
  local amount = 0.09   -- scale delta (0.06 = ±6%)
  
  local base = self.previewBaseScale
  local t = ElapsedTime
  
  local pulse = 1 + math.sin(t * speed) * amount
  local s = base * pulse
  
  e.scale = vec3(s, s, s)
end

function drawGameOverOverlay()
  if not match or not match.gameEnded then return end
  
  local winSeat = match.winnerSeat
  local mySeat = match.activeLocalSeat or 1  -- if you have Local.mySeat later, swap it in
  
  local title = (winSeat == mySeat) and "You win" or "You lose"
  local sub = "tap for new game"
  
  pushStyle()
  rectMode(CORNER)
  fill(0, 0, 0, 170)
  rect(0, 0, WIDTH, HEIGHT)
  
  textAlign(CENTER)
  fontSize(72)
  fill(255)
  text(title, WIDTH/2, HEIGHT*0.58)
  
  fontSize(26)
  fill(255, 255, 255, 200)
  text(sub, WIDTH/2, HEIGHT*0.45)
  popStyle()
end