TileModel = class()

OPPOSITE_SIDE = {4,5,6,1,2,3}
DIR_TO_SIDE = {4,5,6,1,2,3}  

function TileModel:init(id, sides, kind)
  self.id = id or "X"
  self.sides = sides or {"red","red","purple","purple","red","purple"} -- 1..6
  self.kind = kind or "normal" -- "normal" | "candidate"
end

function TileModel:rotate(dir)
  if dir == "left" then
    local first = self.sides[1]
    for i=1,5 do self.sides[i] = self.sides[i+1] end
    self.sides[6] = first
  else
    local last = self.sides[6]
    for i=6,2,-1 do self.sides[i] = self.sides[i-1] end
    self.sides[1] = last
  end
end

function TileModel:otherTileMatchesMySide(otherTile, mySide)
  local theirSide = OPPOSITE_SIDE[mySide]
  return self.sides[mySide] == otherTile.sides[theirSide]
end

function TileModel:clone()
  local copy = TileModel(self.id, nil, self.kind)
  copy.sides = {}
  for i=1,6 do
    copy.sides[i] = self.sides[i]
  end
  return copy
end