--# Match
Match = class()

function Match:init()
  self.seats = {
    [1] = { id = "local", score = 0 },
    [2] = { id = "opponent", score = 0 }
  }
  self.activeSeat = 1
  self.winScore =  12
  self.gameEnded = false
  self.winnerSeat = nil
end

function Match:endTurn()
  if self.gameEnded then return end
  
  -- advance seat
  self.activeSeat = 3 - self.activeSeat
  
  -- check win condition AFTER scoring, BEFORE next turn
  self:checkForGameEnd()
end

function Match:reset()
  self.gameEnded = false
  self.winnerSeat = nil
  self.activeSeat = 1
  
  for _,seat in ipairs(self.seats) do
    seat.score = 0
  end
end

function Match:checkForGameEnd()
  for i,seat in pairs(self.seats) do
    if seat.score >= self.winScore then
      self.gameEnded = true
      self.winnerSeat = i
      print("game ended")
      return true
    end
  end
  return false
end

function Match:winnerSeat()
  for i,seat in pairs(self.seats) do
    if seat.score >= self.winScore then
      return i
    end
  end
end

function Match:currentSeat()
  local seat = self.seats[self.activeSeat]
  assert(seat, "Match: no seat for activeSeat=" .. tostring(self.activeSeat))
  return seat
end

function Match:addScore(points)
  self:currentSeat().score =
  self:currentSeat().score + points
end

function Match:isLocalTurn()
  return self.activeSeat == 1
end

function Match:getScores()
  local t = {}
  for i,seat in ipairs(self.seats) do
    t[i] = seat.score
  end
  return t
end

function Match:setScoresTo(scores)
  assert(scores, "Match:setScoresTo missing scores")
  
  for i,seat in ipairs(self.seats) do
    seat.score = scores[i] or 0
  end
end