require(asset.documents.Bestagons_2D)
require(asset.documents.FullOrbitViewer)
require(asset.documents.immediateUI)

MODE2D, MODE3D = 1, 2
MODE = MODE3D
USE_DUMMY_GC = true
LOCAL_AI_ENABLED = true

parameter.boolean("modeToggle", true, function(v)
  MODE = v and MODE3D or MODE2D
end)

function setup()
  viewer.mode = FULLSCREEN
  
  viewController = objc.viewer
  if USE_DUMMY_GC then
    gc = DummyGCSession()
  else
    gc = GCSession()
  end
  tbmmDelegate = TBMMDelegate()
  
  -- SHARED MODEL
  currentAvailableColors = randomUniqueColors(2)
  board = BoardModel()
  board:spawnInitialTiles()
 
  match = Match(board)
  -- 2D renderer
  renderer2D = HexRenderer2D(board, 42)
  ui2D = UI2D(board, renderer2D)
  
  -- 3D renderer
  setup3D()
  
  setupUITweaks()
  
  localPlayer = objc.GKLocalPlayer.localPlayer
  localPlayer.authenticateHandler = authenticateHandler
end

function setup3D()
  assert(craft)
  scene = craft.scene()
  scene.sky.material.sky = color(72, 235, 215)       
  scene.sky.material.horizon = color(34, 30, 66)       
  scene.sky.material.ground = color(60, 74, 200)
  scene.ambientColor = color(210)
  orbitViewer = scene.camera:add(FullOrbitViewer, vec3(0,0,0), 10, 1, 1000)
  orbitViewer:setPosition(vec3(0, 0, -19.65))
  orbitViewer:toggleDoubleTapRecentering()
  orbitViewer:setFixedAngleToHorizon(45)
  sync3DTilesFromBoard(board)
  gameInit()
  highlighPlayableHexes()
  touchStarts = {}
  activeCandidateSwipe = {}  -- touchId -> {startX, ent}
  ui3D = UI3D(scene, orbitViewer)
  ui3D:refreshPreviewFrom(board)
end

function draw()
  if MODE == MODE2D then
    draw2D()
  else
    draw3D()
  end
  updateSkyCycle(DeltaTime)
  
  if Game.aiThinking and ElapsedTime >= Game.aiThinkUntil then
    Game.aiThinking = false
    
    runAITurn()
    
    -- visual feedback ONLY (no game-state mutation)
    local last = board.lastCommit
    if last then
      local ent = Game.tiles3D[keyQR(last.q, last.r)]
      if ent then
        spawnOpponentGlowAtTile(ent)
      end
    end
  end
  
  drawActivityOverlay(Game.aiThinking, "Opponent thinking…")
  drawGameOverOverlay()
  
  button("PLACE", WIDTH - 90, 60, 80, 40, function()
    runLocalPlayerTurn()
  end, 20)
  --[[
  button("MODE", WIDTH - 200, 60, 80, 40, function()
    if MODE == MODE2D then
      MODE = MODE3D 
      else
      MODE = MODE2D
    end
  end, 20)
  ]]
end

function touched(t)
  if handleGameOverTap(t) then return end
  immediateUI(t)
  
  if MODE == MODE2D then
    touched2D(t)
  else
    touched3D(t)
  end
end

function draw2D()
  background(20,20,40)
  renderer2D:update()
  ui2D:drawMatchCount()
end

function draw3D()
  scene:update(DeltaTime)
  scene:draw()
  if not Game.aiThinking then
    drawCandidateMatchCount()
    drawOpponentLastMovePoints()
  end
  ui3D:update()
end

function touched2D(t)
  if t.state ~= ENDED then return end
  
  -- rotate
  local q,r = ui2D:candidateTapped(t)
  if q then
    board:rotateTile(q, r, "left")
    sync3DTilesFromBoard(board)        -- ✅ add
    highlighPlayableHexes()   -- optional; only if rotation affects playables
    return
  end
  
  -- move
  local q2,r2 = ui2D:playableHexTapped(t)
  if q2 then
    ui2D:moveCandidate(q2,r2)
    sync3DTilesFromBoard(board)
  end
end

function touched3D(t)
  if not orbitSeen then 
    activeCandidateSwipe = {}
    orbitSeen = orbitSeen or {}
  end
  local id = t.id
  
  local function forwardToOrbit()
    orbitSeen[id] = true
    touches.touched(t)
  end
  
  -- 1) Tap to place candidate (already proven solid)
  local q, r = tappedPlayableHighlight(t)
  if q then
    moveCandidate3D(q, r)
    
    if orbitSeen[id] then
      cancelOrbitTouch(t)
      orbitSeen[id] = nil
    end
    return
  end
  
  ----------------------------------------------------------------
  -- 2) BEGIN: detect swipe start INSIDE candidate only
  ----------------------------------------------------------------
  if t.state == BEGAN then
    local ent = getCandidate3DEntity()
    if ent and candidateHitTest3D(t) then
      activeCandidateSwipe[id] = {
        startX = t.x,
        startY = t.y,
        ent = ent,
        claimed = false
      }
      return -- do NOT forward to orbit yet
    end
    
    -- not candidate → normal orbit begin
    forwardToOrbit()
    return
  end
  
  ----------------------------------------------------------------
  -- 3) MOVE: decide if swipe becomes rotation
  ----------------------------------------------------------------
  if t.state == MOVING then
    local swipe = activeCandidateSwipe[id]
    if swipe then
      local dx = t.x - swipe.startX
      local dy = t.y - swipe.startY
      
      -- horizontal intent only
      if not swipe.claimed then
        if math.abs(dx) > 20 and math.abs(dx) > math.abs(dy) then
          swipe.claimed = true
          
          -- cancel orbit if it already saw this touch
          if orbitSeen[id] then
            cancelOrbitTouch(t)
            orbitSeen[id] = nil
          end
        end
      end
      
      return -- swallow movement (claimed or undecided)
    end
    
    forwardToOrbit()
    return
  end
  
  ----------------------------------------------------------------
  -- 4) END: apply rotation if claimed
  ----------------------------------------------------------------
  if t.state == ENDED then
    local swipe = activeCandidateSwipe[id]
    if swipe then
      local dx = t.x - swipe.startX
      
      if swipe.claimed then
        local dir = (dx > 0) and "right" or "left"
        rotate3D(dir, swipe.ent)
      end
      
      activeCandidateSwipe[id] = nil
      orbitSeen[id] = nil
      return
    end
    
    orbitSeen[id] = nil
    forwardToOrbit()
    return
  end
  
  ----------------------------------------------------------------
  -- 5) CANCEL
  ----------------------------------------------------------------
  if t.state == CANCELLED then
    activeCandidateSwipe[id] = nil
    orbitSeen[id] = nil
    forwardToOrbit()
  end
end