function cancelOrbitTouch(t)
  local cancel = {
    id = t.id,
    x = t.x, y = t.y,
    prevX = t.prevX, prevY = t.prevY,
    deltaX = 0, deltaY = 0,
    state = CANCELLED
  }
  touches.touched(cancel)
end

function handleGameOverTap(t)
  if not match or not match.gameEnded then return false end
  if t.state ~= ENDED then return true end
  
  newGame()
  return true
end

function candidateHitTest3D(t)
  local ent = getCandidate3DEntity()
  if not ent then return nil end
  
  local cam = scene.camera:get(craft.camera)
  if not cam then return nil end
  
  -- project center
  local centerWS = ent:transformPoint(vec3(0,0,0))
  local centerSP = cam:worldToScreen(centerWS)
  
  -- pick a representative vertex on the top ring
  local model = ent.model
  if not model or not model.positions then return nil end
  
  -- vertex 2 is first outer vertex in your mesh
  local edgeWS = ent:transformPoint(model.positions[2])
  local edgeSP = cam:worldToScreen(edgeWS)
  
  -- dynamic radius in screen space
  local radius = (edgeSP - centerSP):len()
  
  -- pad slightly to be forgiving
  radius = radius * 1.15
  
  local dx = t.x - centerSP.x
  local dy = t.y - centerSP.y
  
  if dx*dx + dy*dy <= radius*radius then
    return ent
  end
end

function drawActivityOverlay(isOn, msg)
  if not isOn then return end
  
  pushStyle()
  
  -- dim background
  rectMode(CORNER)
  noStroke()
  fill(0, 0, 0, 120)
  rect(0, 0, WIDTH, HEIGHT)
  
  -- message
  fill(255, 255, 255, 230)
  fontSize(28)
  textAlign(CENTER)
  textMode(CENTER)
  
  local cx, cy = WIDTH/2, HEIGHT/2
  if msg then
    text(msg, cx, cy + 40)
  end
  
  -- spinner
  local r = 18
  local t = ElapsedTime * 6
  strokeWidth(4)
  lineCapMode(ROUND)
  noFill()
  
  for i = 0, 11 do
    local a = t + i * (math.pi * 2 / 12)
    local ax = cx + math.cos(a) * r
    local ay = cy - 10 + math.sin(a) * r
    local bx = cx + math.cos(a) * (r * 0.55)
    local by = cy - 10 + math.sin(a) * (r * 0.55)
    
    local alpha = 40 + (i / 11) * 180
    stroke(255, 255, 255, alpha)
    line(ax, ay, bx, by)
  end
  
  popStyle()
end

function screenToWorldOnY0(px, py)
  local cam = scene.camera:get(craft.camera)
  if not cam or not cam.screenToRay then return nil end
  
  local o, d = cam:screenToRay(vec2(px, py))
  
  if not o or not d then return nil end
  if math.abs(d.y) < 1e-6 then return nil end
  
  local t = -o.y / d.y
  if t < 0 then return nil end
  
  return o + d * t
end

function worldToScreenSafe(p)
  local cam = scene.camera:get(craft.camera)
  if not cam then return end
  return cam:worldToScreen(p)
end

function setInitialOrbitView(target, zoom, pitchDeg, yawDeg)
  target = target or vec3(0,0,0)
  zoom   = zoom   or 14
  pitchDeg = pitchDeg or -35
  yawDeg   = yawDeg   or 0
  
  -- 1) seed OrbitViewer state (sticks)
  if orbitViewer then
    if orbitViewer.target ~= nil then orbitViewer.target = target end
    if orbitViewer.origin ~= nil then orbitViewer.origin = target end
    
    if orbitViewer.zoom ~= nil then
      orbitViewer.zoom = zoom
    elseif orbitViewer.distance ~= nil then
      orbitViewer.distance = zoom
    end
    
    -- some OrbitViewer variants use a quaternion field
    if orbitViewer.q ~= nil then
      orbitViewer.q = quat.eulerAngles(pitchDeg, yawDeg, 0)
    end
  end
end

function drawConfirmButton()
  local y = HEIGHT * 0.15
  local pad = 80
  local size = 64
  
  pushStyle()
  textAlign(CENTER)
  fontSize(40)
  fill(Colors.buttonBG)
  -- CONFIRM (✓)
  button("✓",
  WIDTH*0.5 + pad, y,
  size, size,
  function()
    -- for now same behavior
  end,
  24
  )
  
  popStyle()
end