playableHighlights = {}

function highlightHexAt(hexPos)
  highlightModel = highlightModel or createHighlightHex()
  
  -- WAS: local p = coordsOfHexPosition(hexPos.q, hexPos.r, 1)
  local p = coordsOfHexPosition(hexPos.q, hexPos.r, Game.radius)
  
  local e = scene:entity()
  e.model = highlightModel
  e.material = craft.material(asset.builtin.Materials.Basic)
  e.material.blend = true
  
  e.position = p
  
  -- ADD: keep highlights with the board
  e.parent = boardRoot
  
  return e
end

function createHighlightHex()
  local m = craft.model()
  
  local verts,norms,cols,uvs,idx = {},{},{},{},{}
  local r = 0.82   -- smaller than tile
  local y = 0.01   -- float above surface
  
  -- center
  table.insert(verts, vec3(0,y,0))
  table.insert(norms, vec3(0,1,0))
  table.insert(cols, color(255,255,100,180))
  table.insert(uvs, vec2(0.5,0.5))
  
  -- ring
  for i=0,5 do
    local a = math.rad(i*60)
    local x = r*math.cos(a)
    local z = r*math.sin(a)
    
    local fade = 80   -- softer edge
    table.insert(verts, vec3(x,y,z))
    table.insert(norms, vec3(0,1,0))
    table.insert(cols, color(255,255,100,fade))
    table.insert(uvs, vec2(0,0))
  end
  
  for i=2,7 do
    local n = (i==7) and 2 or i+1
    table.insert(idx,1)
    table.insert(idx,i)
    table.insert(idx,n)
  end
  
  m.blend = true
  m.positions=verts
  m.normals=norms
  m.colors=cols
  m.uvs=uvs
  m.indices=idx
  
  return m
end

function setupPreviewTile()
  spinPivot = scene:entity()
  spinPivot.parent = orbitViewer.entity
  
  -- fixed camera-space offset
  spinPivot.position = vec3(0, 0.9, 3.45)
  
  -- permanent tilt
  spinPivot.eulerAngles = vec3(-68, 0, 0)
  
  Game.previewEnt.parent = spinPivot
  Game.previewEnt.position = vec3(0,0,0)
  Game.previewEnt.scale = vec3(0.4,0.4,0.4)
  --    Game.previewEnt._yaw = 0
end

function updatePreviewTile(force)
  if not Game or not Game.previewEnt then
    print("updatePreviewTile: no previewEnt")
    return
  end
  
  local colors = colorsFromSideNames(Game.previewEnt.model2D.sides)
  local tex = standardHexTexture(colors)
  if not tex then
    print("updatePreviewTile: missing tileTextures[" .. tostring(name) .. "]")
    return
  end
  
  if (not force) and Game._previewColorName == name then
    return
  end
  
  Game._previewColorName = name
  
  -- ensure the material exists (createHexTile should have made it, but guard anyway)
  if not Game.previewEnt.material then
    print("updatePreviewTile: previewEnt.material is nil (creating Standard)")
    Game.previewEnt.material = craft.material("Materials:Standard")
  end
  
  -- critical: Standard material WILL tint texture unless diffuse is white
  Game.previewEnt.material.diffuse = color(255)
  Game.previewEnt.material.map = tex
  end
  
  local function shortestYawTarget(startYaw, targetBaseYaw)
  -- Returns a target yaw equivalent to targetBaseYaw (mod 360),
  -- but chosen so the delta from startYaw is in [-180, +180].
  local delta = ((targetBaseYaw - startYaw + 180) % 360) - 180
  return startYaw + delta
  end
  
  function setScreenPositionOfBottomOfPreviewTile()
  local cam = scene.camera:get(craft.camera)
  if not cam or not Game.previewEnt then
  print("not Game.previewEnt") return end
  
  local m = Game.previewEnt.model
  if not m or not m.positions then return end
  
  local verts = {}
  
  -- transform all verts to screen space
  for i,v in ipairs(m.positions) do
  local wp = Game.previewEnt:transformPoint(v)
  local sp = cam:worldToScreen(wp)
  table.insert(verts, sp)
  end
  
  -- find lowest Y
  local lowestY = math.huge
  for i,v in ipairs(verts) do
  if v.y < lowestY then
  lowestY = v.y
  end
  end
  
  -- collect verts near that bottom
  local bottom = {}
  for i,v in ipairs(verts) do
  if math.abs(v.y - lowestY) < 3 then
  table.insert(bottom, v)
  end
  end
  
  -- average them (edge midpoint)
  local sx, sy = 0, 0
  for i,v in ipairs(bottom) do
  sx = sx + v.x
  sy = sy + v.y
  end
  
  previewTileBottomOnScreen =
  vec2(sx / #bottom, sy / #bottom)
  end
  
  function highlighPlayableHexes()
    -- clear old
    for i,e in ipairs(playableHighlights) do
    e.active = false
    end
    playableHighlights = {}
    
    -- SOURCE OF TRUTH: BoardModel
    local spots = board:playableHexes()
    
    for i,pos in ipairs(spots) do
    local h = highlightHexAt(pos)
    h._q = pos.q
    h._r = pos.r
    playableHighlights[#playableHighlights+1] = h
    end
    end
    
    function tappedPlayableHighlight(t)
    -- 🔒 swallow tap if this touch was a candidate swipe
    if activeCandidateSwipe[t.id] then return end
    
    if t.state ~= ENDED then return end
    
    local cam = scene.camera:get(craft.camera)
    if not cam then return end
    
    for i,e in ipairs(playableHighlights) do
    if e.active then
    -- WAS: local sp = cam:worldToScreen(e.position)
    local wp = e:transformPoint(vec3(0,0,0)) -- world position
    local sp = cam:worldToScreen(wp)
    
    local dx = t.x - sp.x
    local dy = t.y - sp.y
    
    if dx*dx + dy*dy < 50*50 then
    return e._q, e._r
    end
    end
    end
  end