-- q,r are axial coords (0,0 = center)
function coordsOfHexPosition(q, r, radius)
  local w = radius * 2
  local h = math.sqrt(3) * radius
  
  local x = -radius * 1.5 * q
  local z = h * (r + q*0.5)
  
  return vec3(x, 0, z)
end

function axialRound(q, r)
  -- cube round
  local x, z = q, r
  local y = -x - z
  
  local rx = math.floor(x + 0.5)
  local ry = math.floor(y + 0.5)
  local rz = math.floor(z + 0.5)
  
  local dx = math.abs(rx - x)
  local dy = math.abs(ry - y)
  local dz = math.abs(rz - z)
  
  if dx > dy and dx > dz then
    rx = -ry - rz
  elseif dy > dz then
    ry = -rx - rz
  else
    rz = -rx - ry
  end
  
  return rx, rz
end

function worldToAxialFlat(x, z, radius)
  -- inverse of your coordsOfHexPosition (flat-top axial)
  local q = -(2/3) * x / radius
  local r = (z / (math.sqrt(3) * radius)) - (q * 0.5)
  return axialRound(q, r)
end

function keyQR(q,r) return q .. "," .. r end

function oppEdge(i) return ((i+2)%6)+1 end -- 1<->4, 2<->5, 3<->6

function rotToYaw(rot)
  rot = rot or 0
  return (rot % 6) * 60 - 60
end

local function shortestYawTarget(startYaw, targetBaseYaw)
  -- Returns a target yaw equivalent to targetBaseYaw (mod 360),
  -- but chosen so the delta from startYaw is in [-180, +180].
  local delta = ((targetBaseYaw - startYaw + 180) % 360) - 180
  return startYaw + delta
end