GCSession = class()

function GCSession:init()
  self.localPlayer = objc.GKLocalPlayer.localPlayer
  self.listener = LocalPlayerListenerType()
  self.localPlayer:registerListener_(self.listener)
  
  self.match = nil
  self.localSeat = nil
  self.isMyTurn = false
end

function GCSession:createMatch()
  local request = objc.GKMatchRequest()
  request.minPlayers = 2
  request.maxPlayers = 2
  request.playerGroup = 1911316125
  
  local vc =
  objc.GKTurnBasedMatchmakerViewController:alloc()
  :initWithMatchRequest_(request)
  
  vc.turnBasedMatchmakerDelegate = tbmmDelegate
  viewController:presentModalViewController_animated_(vc, true)
end

function GCSession:attachMatch(match)
  self.match = match
  
  local localId = self.localPlayer.playerID
  local players = match.participants
  
  -- determine seat
  for i,p in ipairs(players) do
    if p.playerID == localId then
      self.localSeat = i
      break
    end
  end
  
  assert(self.localSeat, "GCSession: local seat not found")
  
  -- apply incoming state if present
  if match.matchData then
    local str = objc.NSString:alloc()
    :initWithData_encoding_(match.matchData, 4)
    local t = json.decode(str:UTF8String())
    
    if t then
      if t.board then
        board:deserialize(t.board)
      end
      if t.scores then
        match:setScoresTo(t.scores)
      end
      if t.activeSeat then
        match.activeSeat = t.activeSeat
      end
      
      -- reflect visuals
      sync3DTilesFromBoard(board)
      highlighPlayableHexes()
      ui3D:refreshPreviewFrom(board)
    end
  end
  
  -- determine turn ownership
  self.isMyTurn =
  match.currentParticipant.playerID == localId
end

function GCSession:endTurn()
  assert(self.match, "GCSession:endTurn: no match")
  
  local state = serializeGameState()
  local jsonStr = json.encode(state)
  
  local data = objc.NSString:stringWithUTF8String_(jsonStr)
  :dataUsingEncoding_(4) -- UTF-8
  
  local next = self.match.participants[3 - self.localSeat]
  
  self.match:endTurnWithNextParticipants_turnTimeout_matchData_(
  { next },
  objc.GKTurnTimeoutDefault,
  data
  )
  
  self.isMyTurn = false
end

TBMMDelegate = objc.class("TBMMDelegate")

function TBMMDelegate:turnBasedMatchmakerViewControllerWasCancelled_(vc)
  viewController:dismissModalViewControllerAnimated_(true, nil)
  print("GC TBMM: cancelled")
end

function TBMMDelegate:turnBasedMatchmakerViewController_didFailWithError_(vc, err)
  viewController:dismissModalViewControllerAnimated_(true, nil)
  print("GC TBMM error:", err and err.localizedDescription)
end

function TBMMDelegate:turnBasedMatchmakerViewController_didFindMatch_(vc, match)
  viewController:dismissModalViewControllerAnimated_(true, nil)
  
  -- hand off to GCSession (or DummyGCSession safely ignores)
  gc:attachMatch(match)
end

LocalPlayerListenerType = objc.delegate("GKLocalPlayerListener")

function LocalPlayerListenerType:
  player_receivedTurnEventForMatch_didBecomeActive_(
  player, match, didBecomeActive
  )
  
  gc:attachMatch(match)
end

function serializeGameState()
  return {
    board      = board:serialize(),
    scores     = match:getScores(),
    activeSeat = match.activeSeat
  }
end

