DummyGCSession = class()

function DummyGCSession:init()
  self.localSeat = 1
  self.isMyTurn = true
  self._lastData = nil
end

function DummyGCSession:createMatch()
  print("DummyGCSession:createMatch (no-op)")
end

function DummyGCSession:attachMatch(_)
  print("DummyGCSession:attachMatch (no-op)")
end

function DummyGCSession:endTurn()
  -- EXACTLY the same payload as real GC
  local state = serializeGameState()
  local jsonStr = json.encode(state)
  self._lastData = jsonStr
  
  print("DummyGCSession:endTurn → sending")
  print(jsonStr)
  
  self.isMyTurn = false
  
  -- simulate remote player thinking, then sending back
  self:simulateIncomingTurn(jsonStr)
end

function DummyGCSession:simulateIncomingTurn(jsonStr)
  print("DummyGCSession:simulateIncomingTurn")
  
  local t = json.decode(jsonStr)
  assert(t, "DummyGCSession: bad json")
  
  -- apply EXACTLY like GCSession:attachMatch
  if t.board then
    board:deserialize(t.board)
  end
  
  if t.scores then
    match:setScoresTo(t.scores)
  end
  
  if t.activeSeat then
    -- simulate opponent completing their turn
    match.activeSeat = 3 - t.activeSeat
  end
  
  -- rebuild visuals (same as GC path)
  sync3DTilesFromBoard(board)
  highlighPlayableHexes()
  ui3D:refreshPreviewFrom(board)
  
  self.isMyTurn = true
  print("DummyGCSession: turn returned to local")
end