function debugDraw()
  showSideNames()
  showPreviewNeighbors()
  showSharedBorders()
end

function showSideNamesForTile(tile)
  if true then return end
  
  if not tile or not tile.model or not tile.model.positions then return end
  
  local cam = scene.camera:get(craft.camera)
  if not cam then return end
  
  local pos = tile.model.positions
  
  pushStyle()
  textAlign(CENTER)
  fontSize(18)
  
  for worldSide = 1,6 do
    
    local name = tile.model2D and tile.model2D.sides[worldSide]
    local col = EDGE_COLORS[name]
    
    -- geometry ONLY for placement
    local i1 = 1 + worldSide
    local i2 = (worldSide == 6) and 2 or (i1 + 1)
    
    local v1 = pos[i1]
    local v2 = pos[i2]
    
    local mid = (v1 + v2) * 0.5
    local outward = vec3(mid.x, 0, mid.z)
    if outward:len() > 1e-6 then outward = outward:normalize() end
    
    -- pull label INWARD onto the wedge instead of outside it
    local localP = mid - outward * 0.25 + vec3(0, 0.08, 0)
    local worldP = tile:transformPoint(localP)
    local sp = cam:worldToScreen(worldP)
    
    local label = name or "?"
    local tw, th = textSize(label)
    
    fill(255,255,255,220)
    rectMode(CENTER)
    rect(sp.x, sp.y + 10, tw + 10, th + 6)
    
    fill(col.r, col.g, col.b, 255)
    text(label, sp.x, sp.y + 10)
  end
  
  popStyle()
end

function showSideNames()
  for _,ent in pairs(Game.tiles3D) do
    if ent and ent.active ~= false then
      showSideNamesForTile(ent)
    end
  end
end

function showPreviewNeighbors()
  if not Game.previewPreviewPosition then return end
  
  local cam = scene.camera:get(craft.camera)
  if not cam then return end
  
  local q = Game.previewPreviewPosition.q
  local r = Game.previewPreviewPosition.r
  
  pushStyle()
  noStroke()
  fill(0,255,0,180)
  
  for i=1,6 do
    local d = HEX_DIRS[i]
    local nq = q + d.q
    local nr = r + d.r
    
    local ent = Game.tiles3D[keyQR(nq,nr)]
    if ent then
      local wp = ent.position + vec3(0,0.18,0)
      local sp = cam:worldToScreen(wp)
      
      ellipse(sp.x, sp.y, 28, 28)
    end
  end
  
  popStyle()
end

function showSharedBorders()
  if not Game.previewPreviewPosition then return end
  
  local cam = scene.camera:get(craft.camera)
  if not cam then return end
  
  local q = Game.previewPreviewPosition.q
  local r = Game.previewPreviewPosition.r
  
  pushStyle()
  rectMode(CENTER)
  noStroke()
  fill(255,0,0,200)
  
  for i=1,6 do
    local d = HEX_DIRS[i]
    local nq = q + d.q
    local nr = r + d.r
    
    local ent = Game.tiles3D[keyQR(nq,nr)]
    if ent then
      -- midpoint between preview hex and neighbor
      local p0 = coordsOfHexPosition(q,  r,  Game.radius)
      local p1 = coordsOfHexPosition(nq, nr, Game.radius)
      local mid = (p0 + p1) * 0.5 + vec3(0,0.2,0)
      
      local sp = cam:worldToScreen(mid)
      
      rect(sp.x, sp.y, 22, 22)
    end
  end
  
  popStyle()
end