EDGE_COLORS = {
  red = color(246, 89, 29),
  green = color(80,255,80),
  blue = color(80,80,255),
  orange= color(255,200,80),
  purple = color(181, 156, 199),
  teal = color(80,220,220)
}
currentAvailableColors = {"red", "purple"}

CENTER_COLOR_3D = color(184, 169, 154)

function randomUniqueColors(n)
  local keys = {}
  for k in pairs(EDGE_COLORS) do
    keys[#keys+1] = k
  end
  
  assert(n <= #keys, "Not enough EDGE_COLORS to pick from")
  
  local out = {}
  for i = 1, n do
    local idx = math.random(1, #keys)
    out[i] = keys[idx]
    table.remove(keys, idx)
  end
  
  return out
end

function colorsFromSideNames(sideNames6)
  assert(sideNames6 and #sideNames6 == 6, "colorsFromSideNames expects 6 side names")
  local t = {}
  t[1] = CENTER_COLOR_3D
  for i=1,6 do
    local name = sideNames6[i]
    local c = EDGE_COLORS[name]
    assert(c, "Unknown EDGE_COLORS name: "..tostring(name))
    t[i+1] = c
  end
  return t
end

function randomSideColors()
  local sides = {}
  for i = 1, 6 do
    sides[i] = currentAvailableColors[math.random(1, #currentAvailableColors)]
  end
  return sides
end