function boardGet(q,r)
  return Game.board[keyQR(q,r)]
end

function boardSet(q,r,tile)
  Game.board[keyQR(q,r)] = tile
end

function isEmpty(q,r)
  return boardGet(q,r) == nil
end

function hasAnyNeighbor(q,r)
  for i=1,6 do
    local d = HEX_DIRS[i]
    if boardGet(q+d.q, r+d.r) then return true end
  end
  return false
end

function placeCurrentTileAt(q,r)
  local names = Game.previewEnt.colorNames
  local tile = createHexTile(names)
  tile._q = q
  tile._r = r
  tile.position = coordsOfHexPosition(q, r, 1)
  tile.rot = Game.previewEnt.rot
  tile.eulerAngles = vec3(0, rotToYaw(tile.rot), 0)
  
  boardSet(q,r,tile)
  
  -- next tile
  Game.previewEnt = createHexTile()
  updatePreviewTile(true)
  
  Game.previewEnt.rot = 0
  Game.previewEnt._animYaw = nil
  Game.previewEnt.eulerAngles = vec3(0, rotToYaw(Game.previewEnt.rot), 0)
  
  highlighPlayableHexes()
  end
  
  function getCandidate3DEntity()
  local cell = board:getCandidateCell()
  if cell and cell.tile.kind == "candidate" then
  return Game.tiles3D[keyQR(cell.q, cell.r)]
  end
  end
  
  function spawnInitialTiles3D(board)
  -- create the craft entities from the board's existing tiles
  for _,cell in ipairs(board:allHexCellsAsFlatList()) do
  local e = createHexTileFromTileModel(cell.tile)
  e._q, e._r = cell.q, cell.r
  e.position = coordsOfHexPosition(cell.q, cell.r, Game.radius)
  e.rot = cell.tile.rot or 0
  e.eulerAngles = vec3(0, rotToYaw(e.rot), 0)
  
  e.parent = boardRoot
  
  -- keep your existing Game.board lookup if you still want it
  boardSet(cell.q, cell.r, e)
  end
end