---------------------------------------------------------
-- 1) ROUNDED RECTANGLE CODE
---------------------------------------------------------

__RRects = {}

function roundedRectangle(t)
    local s = t.radius or 8
    local c = t.corners or 15  -- 15 => round all corners
    local w = math.max(t.w+1, 2*s) + 1
    local h = math.max(t.h, 2*s) + 2
    
    local mode = rectMode()
    if mode == CORNER then
        t.x = t.x + t.w/2
        t.y = t.y + t.h/2
    end
    
    local label = table.concat({
        w, h, s, c,
        mode, -- check rectMode
        0, 0
    }, ",")
    
    if not __RRects[label] then
        local rr = mesh()
        rr.shader = shader(rrectshad.vert, rrectshad.frag)
        
        local v, no = {}, {}
        local n = math.max(3, s//2)
        local edge, cent = vec3(0,0,1), vec3(0,0,0)
        
        local function cornerPoly(dx, dy, o)
            for i = 1, n do
                table.insert(v, o)
                table.insert(v, o + vec2(dx*s*math.cos((i-1)*math.pi/(2*n)), dy*s*math.sin((i-1)*math.pi/(2*n))))
                table.insert(v, o + vec2(dx*s*math.cos(i*math.pi/(2*n)),   dy*s*math.sin(i*math.pi/(2*n))))
                
                table.insert(no, cent)
                table.insert(no, edge)
                table.insert(no, edge)
            end
        end
        
        local function cornerBlock(o, dx, dy)
            v[#v+1] = o
            v[#v+1] = o + vec2(dx*s, 0)
            v[#v+1] = o + vec2(dx*s, dy*s)
            
            v[#v+1] = o
            v[#v+1] = o + vec2(0, dy*s)
            v[#v+1] = o + vec2(dx*s, dy*s)
            
            local blockNormals = {cent, edge, edge, cent, edge, edge}
            for i=1,#blockNormals do
                no[#no+1] = blockNormals[i]
            end
        end
        
        -- Build the corners
        for j = 1, 4 do
            local dx = 1 - 2*(((j+1)//2)%2)
            local dy = -1 + 2*((j//2)%2)
            local o = vec2(dx*(w*0.5 - s), dy*(h*0.5 - s))
            local bit = 2^(j-1)
            
            if c & bit == bit then
                cornerPoly(dx, dy, o)
            else
                cornerBlock(o, dx, dy)
            end
        end
        
        rr.vertices = v
        
        -- Now add center rectangles
        rr:addRect(0, 0,         w-2*s, h-2*s)
        rr:addRect(0, (h-s)/2,   w-2*s, s)
        rr:addRect(0, -(h-s)/2,  w-2*s, s)
        rr:addRect(-(w-s)/2, 0,  s, h-2*s)
        rr:addRect((w-s)/2,  0,  s, h-2*s)
        
        -- Normals for center parts
        local centerNormals = {
            cent,cent,cent, cent,cent,cent,
            edge,cent,cent, edge,cent,edge,
            cent,edge,edge, cent,edge,cent,
            edge,edge,cent, edge,cent,cent,
            cent,cent,edge, cent,edge,edge
        }
        for i=1,#centerNormals do
            no[#no+1] = centerNormals[i]
        end
        
        rr.normals = no
        rr.shader.scale = 0.25 / math.max(2, s)
        
        local sc = 0.25/math.max(2, s)
        rr.shader.strokeWidth = math.min( 1 - sc*3, strokeWidth() * sc)
        
        __RRects[label] = rr
        __RRects[label] = rr
        if __RRects.__prewarm then 
            return rr 
        end  
    end
    
    -- Respect the current fill/stroke in Codea
    local rr = __RRects[label]
    
    -- Each time we use this mesh, update a timestamp
    rr._lastUsed = ElapsedTime
    
    rr.shader.fillColor = color(fill())
    if strokeWidth() == 0 then
        rr.shader.strokeColor = rr.shader.fillColor
    else
        rr.shader.strokeColor = color(stroke())
    end
    
    
    pushMatrix()
    translate(t.x, t.y)
    scale(t.scale or 1)
    rr:draw()
    popMatrix()
    
    -- If we don't yet have a "_lastDrawTime" in __RRects, initialize it:
    if not __RRects._lastDrawTime then
        __RRects._lastDrawTime = ElapsedTime
    end
    
    local now = ElapsedTime
    local dt = now - __RRects._lastDrawTime
    __RRects._lastDrawTime = now
    pruneOldMeshes(__RRects, dt * 1.5)
end

function pruneOldMeshes(cache, threshold)
    local now = ElapsedTime
    for key, rr in pairs(cache) do
        -- skip our special _lastDrawTime entry
        if key ~= "_lastDrawTime" then
            if rr._lastUsed and (now - rr._lastUsed) > threshold then
                cache[key] = nil
            end
        end
    end
end

rrectshad = {
    vert = [[
    uniform mat4 modelViewProjection;
    attribute vec4 position;
    attribute vec2 texCoord;
    attribute vec3 normal;
    
    varying highp vec2 vTexCoord;
    varying vec3 vNormal;
    
    void main()
    {
        vTexCoord = texCoord;
        vNormal = normal;
        gl_Position = modelViewProjection * position;
    }
]],

frag = [[
precision highp float;
uniform lowp vec4 fillColor;
uniform lowp vec4 strokeColor;
uniform float scale;
uniform float strokeWidth;
varying highp vec2 vTexCoord;
varying vec3 vNormal;

void main()
{
// Basic fill/stroke blend
lowp vec4 col = mix(strokeColor, fillColor,
smoothstep((1.0 - strokeWidth) - scale * 0.5,
(1.0 - strokeWidth) - scale * 1.5,
vNormal.z));
// Soft alpha on the outer edge
col = mix(vec4(col.rgb, 0.0),
col,
smoothstep(1.0, 1.0 - scale, vNormal.z));
gl_FragColor = col;
}
]]
}