function touchCaptureProof()
    local db = Sensor.getTouchDB()
    local touches = db.touches
    
    -- draw edge gutters so you can deliberately tap “too close to the edge”
    local gutter = 20
    
    pushStyle()
    rectMode(CORNER)
    noStroke()
    
    fill(255, 0, 0, 35)  rect(0, 0, gutter, HEIGHT)                 -- left
    fill(0, 255, 0, 35)  rect(WIDTH-gutter, 0, gutter, HEIGHT)      -- right
    fill(0, 0, 255, 35)  rect(0, 0, WIDTH, gutter)                  -- bottom
    fill(255, 255, 0, 35)rect(0, HEIGHT-gutter, WIDTH, gutter)      -- top
    
    -- draw last-known touch positions
    strokeWidth(0)
    for id, r in pairs(touches) do
        -- dot at current/last x,y
        fill(255, 255, 255, 200)
        ellipse(r.x, r.y, 14)
        
        -- draw began point
        if r.beganX then
            fill(255, 120)
            ellipse(r.beganX, r.beganY, 10)
        end
        
        -- draw ended point
        if r.endedX then
            fill(255, 0, 255, 160)
            ellipse(r.endedX, r.endedY, 10)
        end
    end
    
    -- minimal text readout (no spam printing)
    fill(255)
    fontSize(16)
    textMode(CORNER)
    text("Touch-capture proof: tap all 4 edges + extreme corners", 10, HEIGHT-62)
    text("Dots: white=current, gray=began, magenta=ended", 10, HEIGHT-102)
    
    popStyle()
end

    
    function touchStateName(st)
    if st == BEGAN then return "BEGAN" end
    if st == MOVING then return "MOVING" end
    if st == ENDED then return "ENDED" end
    if st == CANCELLED then return "CANCELLED" end
    return tostring(st)
end

-- Probe a rectangular tap area using the global _IMUI.lastTapLocation path.
-- This does NOT use Sensor at all.
function imuiTapProbe(tag, x, y, w, h)
    _IMUI.handleButtonTouch(x, y, w, h, function()
        local tl = _IMUI.lastTapLocation
        if tl then
            print("PROBE", tag, "tap at", tl.x, tl.y)
        else
            print("PROBE", tag, "tap (no lastTapLocation?)")
        end
    end)
    --print("end of imuiTapProbe firing------------")
end

function deadZone()
    pushStyle()
    rectMode(CENTER)
    
    print("DEADZONE rectMode", rectMode())
    
    fontSize(20)
    fill(81, 236, 67, 75)
    -- Centre control: should work perfectly, both BUTTON + PROBE.
    button("C", WIDTH/2, HEIGHT/2, 80, 80, function()
        print("BUTTON C fired")
    end)
    imuiTapProbe("C", WIDTH/2, HEIGHT/2, 80, 80)
    
    -- LEFT EDGE
    button("L", 40, HEIGHT/2, 80, HEIGHT, function()
        print("BUTTON L fired")
    end)
    imuiTapProbe("L", 40, HEIGHT/2, 80, HEIGHT)
    
    -- RIGHT EDGE
    button("R", WIDTH-40, HEIGHT/2, 80, HEIGHT, function()
        print("BUTTON R fired")
    end)
    imuiTapProbe("R", WIDTH-40, HEIGHT/2, 80, HEIGHT)
    
    -- BOTTOM EDGE
    button("B", WIDTH/2, 40, WIDTH, 80, function()
        print("BUTTON B fired")
    end)
    imuiTapProbe("B", WIDTH/2, 40, WIDTH, 80)
    
    -- TOP EDGE
    button("T", WIDTH/2, HEIGHT-40, WIDTH, 80, function()
        print("BUTTON T fired")
    end)
    imuiTapProbe("T", WIDTH/2, HEIGHT-40, WIDTH, 80)
    
    popStyle()
end

function Sensor.tapUpdateX(event, sensor, t)
    if t.state == BEGAN then
        local inside = sensor:inbox(t)
        local alreadyDown = sensor.touches[t.id] == true
        
        print(
        "TAPDBG BEGAN",
        inside and "IN" or "OUT",
        alreadyDown and "(already down)" or "",
        "id", t.id, "at", t.x, t.y
        )
        
        -- Only initialize once per id while it’s down, and only if inside
        if inside and not alreadyDown then
            sensor.touches[t.id] = true
            event.totalMove = 0
            event.t0 = ElapsedTime
        end
        
    elseif t.state == MOVING and sensor.touches[t.id] then
        event.totalMove = (event.totalMove or 0)
        + abs(t.deltaX) + abs(t.deltaY)
        
    elseif t.state == ENDED then
        if not sensor.touches[t.id] then
            print("TAPDBG ENDED but NO BEGAN for this id",
            t.id, t.x, t.y)
        end
        
        if sensor.touches[t.id] then
            sensor.touches[t.id] = nil
            local duration = ElapsedTime - (event.t0 or 0)
            local movement = event.totalMove or 9999
            
            if duration < 0.5 and movement < 20 then
                event.touch = t
                event:callback()
            end
        end
    end
end