{
	name = "Standard",

	options =
	{
		USE_LOGDEPTHBUF = {false},
		GAMMA_CORRECTION = {true},
		STANDARD = {true},
		PHYSICAL = {true},
		USE_LIGHTING = {true},
		USE_COLOR = {true},
		USE_MAP = {false, {"map"}},
		USE_NORMALMAP = {false, {"normalMap"}},
		USE_ROUGHNESSMAP = {false, {"roughnessMap"}},
		USE_METALNESSMAP = {false, {"metalnessMap"}},
		USE_DISPLACEMENTMAP = {false, {"displacementMap"}},
		USE_AOMAP = {false, {"aoMap"}},
		USE_ENVMAP = {false, {"envMap"}},
		USE_FOG = {false},
		PREMULTIPLIED_ALPHA = {false}
	},

	properties =
	{
		{"offsetRepeat", "vec4", {0,0,1,1}},
		{"diffuse", "vec3", {1,1,1}, color = true},
		{"opacity", "float", 1.0, range = {0,1}},
		{"map", "texture2D"},
		{"normalMap", "texture2D"},
		{"normalScale", "vec2", {0.1, 0.1}},
		{"roughness", "float", 0.0, range = {0,1}},
		{"roughnessMap", "texture2D"},
		{"metalness", "float", 0.0, range = {0,1}},
		{"metalnessMap", "texture2D"},
		{"displacementMap", "texture2D"},
		{"displacementBias", "float", 0.0},
		{"displacementScale", "float", 1.0},
		{"aoMap", "texture2D"},
		{"aoMapIntensity", "float", 0.5},
		{"emissive", "vec3", {0,0,0}, color = true},
		{"envMap", "cubeTexture"},
	},

	pass =
	{
		base = "Surface",

		blendMode = "disabled",
		depthWrite = true,

		vertex =
		[[

			#ifdef USE_DISPLACEMENTMAP
			uniform sampler2D displacementMap;
			uniform float displacementBias;
			uniform float displacementScale;
			#endif

			void vertex(inout Vertex v, out Input o)
			{
				#ifdef USE_DISPLACEMENTMAP
				v.position += v.normal * ( texture( displacementMap, uv ).x * displacementScale + displacementBias );
				#endif
			}
		]],

		surface =
		[[
			#ifdef USE_MAP
			uniform sampler2D map;
			#endif

			#ifdef USE_NORMALMAP
			uniform sampler2D normalMap;
			uniform vec2 normalScale;
			#endif

			#ifdef USE_ROUGHNESSMAP
			uniform sampler2D roughnessMap;
			#endif

			#ifdef USE_METALNESSMAP
			uniform sampler2D metalnessMap;
			#endif

			#ifdef USE_AOMAP
			uniform sampler2D aoMap;
			#endif

			uniform vec3 diffuse;
			uniform vec3 emissive;
			uniform float opacity;
			uniform vec4 offsetRepeat;

			uniform float roughness;
			uniform float metalness;
			uniform float aoMapIntensity;

			void surface(in Input IN, inout SurfaceOutput o)
			{
				vec2 uv = IN.uv * offsetRepeat.zw + offsetRepeat.xy;

				o.diffuse = diffuse;
				o.opacity = opacity;

				#ifdef USE_MAP
				vec4 mapSample = texture(map, uv);
				o.diffuse *= mapSample.rgb;
				o.opacity *= mapSample.a;
				#endif

				o.emission = emissive;
				o.emissive = 1.0;

				o.roughness = roughness;

				#ifdef USE_ROUGHNESSMAP
				o.roughness *= texture(roughnessMap, uv).r;
				#endif

				o.metalness = metalness;

				#ifdef USE_METALNESSMAP
				o.metalness *= texture(metalnessMap, uv).r;
				#endif

				o.occlusion = 1.0;

				#ifdef USE_AOMAP
				o.occlusion *= ( texture( aoMap, uv ).r - 1.0 ) * aoMapIntensity + 1.0;
				#endif

				#ifdef USE_NORMALMAP
				vec3 normal = (texture(normalMap, uv).rgb * 2.0 - 1.0);
				normal.xy *= normalScale;
				o.normal = perturbNormal2Arb( -IN.viewPosition, IN.normal, normal);
				#endif
			}
		]]
	}
}
